#include "iodefine.h"
#include "motor.h"

#define	D_MOTOR_KP					(0.0125)	//	QC
#define	D_MOTOR_DUTY_BASE			(10)		//	{sf[eB
#define	D_MOTOR_DUTY_WIDTH			(5)			//	őduty
#define	D_MOTOR_TARGET_BRIGHTNESS	(435.0)		//	ڕWZTl

//-----------------------------------------------------------------------------
//  T@vF
//    FȂ
//  ߂lFȂ
//-----------------------------------------------------------------------------
void Motor_init(void)
{
	TZ.TSTR.BIT.STR0	= 0;		// ^C}Zch0JEg~

	TZ0.TCR.BIT.TPSC	= 0;		//	Ȃ
	TZ0.TCR.BIT.CKEG	= 0;		//	GbWJEg
	TZ0.TCR.BIT.CCLR	= 1;		//	GRAŃRyA}b`NA

	TZ.TPMR.BIT.PWMB0	= 1;		//	E[^[PWM[h
	TZ.TPMR.BIT.PWMC0	= 1;		//	[^[PWM[h

	//	HighLow֐؂ւg`
	TZ.TOCR.BIT.TOB0	= 0;		//	PWMg`High
	TZ.TOCR.BIT.TOC0	= 0;		//	PWMg`High
	TZ0.POCR.BIT.POLB	= 0;		//	[ANeBu
	TZ0.POCR.BIT.POLC	= 0;		//	[ANeBu

	TZ.TOER.BIT.EB0		= 0;		//	FTIOB0͏o
	TZ.TOER.BIT.EC0		= 0;		//	FTIOC0͏o

	TZ0.TCNT			= 0;		//	JE^NA
	TZ0.GRA				= 12000;	//	1msPWMƂē삳
	TZ0.GRB				= 0;		//	ݒ
	TZ0.GRC				= 0;		//	ݒ
}

//-----------------------------------------------------------------------------
//  T@vFsJn
//    Fdir			E_MOTOR_FORWARD		O
//							E_MOTOR_BACKARD		
//  						E_MOTOR_TURN_RIGHT	E]
//							E_MOTOR_TURN_LEFT	]
//			duty	f[eB(0 - 99)
//  ߂lF0	
//			-1	ُ
//-----------------------------------------------------------------------------
int Motor_runStart(E_MOTOR_DIR dir, unsigned char duty)
{
	//	f[eB100%ȏُ͈툵
	if (duty >= 100)
	{
		return -1;
	}

	//	sɏ]|[g؂ւ
	if (dir == E_MOTOR_FORWARD)
	{
		//	E[^[Oi
		IO.PDR3.BIT.B0 = 1;
		IO.PDR3.BIT.B1 = 0;

		//	[^[Oi
		IO.PDR3.BIT.B2 = 1;
		IO.PDR3.BIT.B3 = 0;
	}
	else if (dir == E_MOTOR_BACKARD)
	{
		//	E[^[
		IO.PDR3.BIT.B0 = 0;
		IO.PDR3.BIT.B1 = 1;

		//	[^[
		IO.PDR3.BIT.B2 = 0;
		IO.PDR3.BIT.B3 = 1;
	}
	else if (dir == E_MOTOR_TURN_RIGHT)
	{
		//	E[^[
		IO.PDR3.BIT.B0 = 0;
		IO.PDR3.BIT.B1 = 1;

		//	[^[Oi
		IO.PDR3.BIT.B2 = 1;
		IO.PDR3.BIT.B3 = 0;
	}
	else if (dir == E_MOTOR_TURN_LEFT)
	{
		//	E[^[Oi
		IO.PDR3.BIT.B0 = 1;
		IO.PDR3.BIT.B1 = 0;

		//	[^[
		IO.PDR3.BIT.B2 = 0;
		IO.PDR3.BIT.B3 = 1;
	}
	else
	{
		return -1;
	}

	//	GRA̎WX^x[XɃf[eB̊ݒ
	TZ0.GRB	= TZ0.GRA * (duty / 100.0);
	TZ0.GRC	= TZ0.GRA * (duty / 100.0);

	TZ.TSTR.BIT.STR0 = 1;		// ^C}Zch0JEgJnPWMJn

	return 0;
}

//-----------------------------------------------------------------------------
//  T@vFON-OFF䑖sJn
//    Fbrightness		ZTl
//			duty			f[eB(0 - 99)
//  ߂lF0	
//			-1	ُ
//-----------------------------------------------------------------------------
int Motor_runOnOff(unsigned short brightness, unsigned char duty)
{

	if (brightness >= 512)		//	Ȃ獶
	{
		//	E[^[Oi
		IO.PDR3.BIT.B0 = 1;
		IO.PDR3.BIT.B1 = 0;

		//	[^[~
		IO.PDR3.BIT.B2 = 1;
		IO.PDR3.BIT.B3 = 1;
	}
	else						//	ȂE
	{
		//	E[^[~
		IO.PDR3.BIT.B0 = 1;
		IO.PDR3.BIT.B1 = 1;

		//	[^[Oi
		IO.PDR3.BIT.B2 = 1;
		IO.PDR3.BIT.B3 = 0;
	}

	//	GRA̎WX^x[XɃf[eB̊ݒ
	TZ0.GRB	= TZ0.GRA * (duty / 100.0);
	TZ0.GRC	= TZ0.GRA * (duty / 100.0);

	TZ.TSTR.BIT.STR0 = 1;		// ^C}Zch0JEgJnPWMJn

	return 0;
}

//-----------------------------------------------------------------------------
//  T@vFP䑖sJn
//    Fbrightness		ZTl
//  ߂lF0	
//			-1	ُ
//-----------------------------------------------------------------------------
int Motor_runPcon(unsigned short brightness)
{
	short dutyDiff;

	//	E[^[Oi
	IO.PDR3.BIT.B0 = 1;
	IO.PDR3.BIT.B1 = 0;

	//	[^[Oi
	IO.PDR3.BIT.B2 = 1;
	IO.PDR3.BIT.B3 = 0;

	//	ڕWɑ΂dutyʂ̎Zo
	dutyDiff = (D_MOTOR_TARGET_BRIGHTNESS - brightness) * D_MOTOR_KP;

	//	ő咲dutył̕␳
	if (dutyDiff > D_MOTOR_DUTY_WIDTH)
	{
		dutyDiff = D_MOTOR_DUTY_WIDTH;
	}
	else if (dutyDiff < -D_MOTOR_DUTY_WIDTH)
	{
		dutyDiff = -D_MOTOR_DUTY_WIDTH;
	}

	//	GRA̎WX^x[XɃf[eB̊ݒ
	TZ0.GRB	= TZ0.GRA * ((D_MOTOR_DUTY_BASE - dutyDiff) / 100.0);	//	E
	TZ0.GRC	= TZ0.GRA * ((D_MOTOR_DUTY_BASE + dutyDiff) / 100.0);	//	

	TZ.TSTR.BIT.STR0 = 1;	// ^C}Zch0JEgJnPWMJn

	return 0;
}

//-----------------------------------------------------------------------------
//  T@vFs~
//    FȂ
//  ߂lF0	
//			-1	ُ
//-----------------------------------------------------------------------------
int Motor_runStop(void)
{
	//	E[^[~
	IO.PDR3.BIT.B0 = 1;
	IO.PDR3.BIT.B1 = 1;

	//	[^[~
	IO.PDR3.BIT.B2 = 1;
	IO.PDR3.BIT.B3 = 1;

	TZ.TSTR.BIT.STR0 = 0;		// ^C}Zch0JEg~PWM~

	return 0;
}

