#include "iodefine.h"
#include "spk.h"

//--------------------------------------------------------------------
//	O[oϐ
//--------------------------------------------------------------------
//	K̃^C}JE^l(128)
const static gScaleTable[] =
{
	179,	//	h
	160,	//	
	142,	//	~
	134,	//	t@
	120,	//	\
	107,	//	
	95,		//	V
	90,		//	h
};

//-----------------------------------------------------------------------------
//  T@vF
//    FȂ
//  ߂lFȂ
//-----------------------------------------------------------------------------
void Spk_init(void)
{
	TV.TCRV1.BIT.ICKS	= 1;	//	128ݒ\
	TV.TCRV0.BIT.CKS	= 0;	//	^C}JEg~
	TV.TCRV0.BIT.CCLR	= 1;	//	Ry}b`AŃJE^NA
	
	TV.TCSRV.BIT.OS		= 9;	//	o͌`	RyA}b`BŃ|[gHigh
								//				RyA}b`AŃ|[gLow
}

//-----------------------------------------------------------------------------
//  T@vF̏o͊Jn
//    Fscale	K̎w
//  ߂lF0	
//			-1	ُ
//-----------------------------------------------------------------------------
int Spk_start(E_SPK_SCALE scale)
{
	//	w艹Kُ͈͈̔`FbN
	if (scale < 0 || scale >= E_SPK_SCALE_END)
	{
		return -1;
	}

	//	f[eB50%̃NbN;
	TV.TCORA	= gScaleTable[scale];
	TV.TCORB	= TV.TCORA / 2;

	//	128Ń^C}JEgJn
	TV.TCRV0.BIT.CKS	= 3;			//	128
	
	return 0;
}

//-----------------------------------------------------------------------------
//  T@vF̏o͒~
//    FȂ
//  ߂lF0	
//			-1	ُ
//-----------------------------------------------------------------------------
int Spk_stop(void)
{
	TV.TCRV0.BIT.CKS	= 0;	//	^C}JEg~
	TV.TCNTV			= 0;	//	^C}JEgl̏
	
	return 0;
}